<?php
// Test script to verify mail system integration in config.php
require_once 'config.php';

header('Content-Type: application/json');

$tests = [];

// Test 1: Check if mail system constants are defined
$tests['mail_constants'] = [
    'MAIL_HOST' => defined('MAIL_HOST'),
    'MAIL_PORT' => defined('MAIL_PORT'),
    'MAIL_USERNAME' => defined('MAIL_USERNAME'),
    'MAIL_PASSWORD' => defined('MAIL_PASSWORD'),
    'MAIL_ENCRYPTION' => defined('MAIL_ENCRYPTION'),
    'MAIL_FROM_EMAIL' => defined('MAIL_FROM_EMAIL'),
    'MAIL_FROM_NAME' => defined('MAIL_FROM_NAME')
];

// Test 2: Check if email template constants are defined
$tests['template_constants'] = [
    'EMAIL_AUTOMATION_ENABLED' => defined('EMAIL_AUTOMATION_ENABLED'),
    'LOG_PATH' => defined('LOG_PATH'),
    'COMPANY_NAME' => defined('COMPANY_NAME'),
    'COMPANY_WEBSITE' => defined('COMPANY_WEBSITE'),
    'SUPPORT_EMAIL' => defined('SUPPORT_EMAIL'),
    'COMPANY_ADDRESS' => defined('COMPANY_ADDRESS')
];

// Test 3: Check if mail functions are available
$tests['mail_functions'] = [
    'sendWelcomeEmail' => function_exists('sendWelcomeEmail'),
    'sendPasswordResetEmail' => function_exists('sendPasswordResetEmail'),
    'sendDepositConfirmationEmail' => function_exists('sendDepositConfirmationEmail'),
    'sendWithdrawalConfirmationEmail' => function_exists('sendWithdrawalConfirmationEmail'),
    'sendKYCApprovalEmail' => function_exists('sendKYCApprovalEmail'),
    'sendKYCRejectionEmail' => function_exists('sendKYCRejectionEmail'),
    'sendAccountVerificationEmail' => function_exists('sendAccountVerificationEmail'),
    'sendTradingAccountCreatedEmail' => function_exists('sendTradingAccountCreatedEmail')
];

// Test 4: Check if IntegratedMailSystem class is available
$tests['mail_system_class'] = class_exists('IntegratedMailSystem');

// Test 5: Check if mail system can be instantiated
try {
    $mailSystem = new IntegratedMailSystem();
    $tests['mail_system_instantiation'] = true;
} catch (Exception $e) {
    $tests['mail_system_instantiation'] = false;
    $tests['mail_system_error'] = $e->getMessage();
}

// Calculate success rate
$total_tests = 0;
$passed_tests = 0;

foreach ($tests as $category => $test_results) {
    if (is_array($test_results)) {
        foreach ($test_results as $test => $result) {
            $total_tests++;
            if ($result === true) {
                $passed_tests++;
            }
        }
    } else {
        $total_tests++;
        if ($test_results === true) {
            $passed_tests++;
        }
    }
}

$success_rate = ($total_tests > 0) ? round(($passed_tests / $total_tests) * 100, 2) : 0;

$response = [
    'success' => true,
    'message' => 'Mail system integration test completed',
    'tests' => $tests,
    'summary' => [
        'total_tests' => $total_tests,
        'passed_tests' => $passed_tests,
        'failed_tests' => $total_tests - $passed_tests,
        'success_rate' => $success_rate . '%'
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT);
?>